# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1488-1 (phpbb2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60361);
 script_cve_id("CVE-2006-4758", "CVE-2006-6839", "CVE-2006-6840", "CVE-2006-6508", "CVE-2006-6841", "CVE-2008-0471");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1488-1 (phpbb2)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to phpbb2
announced via advisory DSA 1488-1.

Several remote vulnerabilities have been discovered in phpBB, a web
based bulletin board.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-0471

Private messaging allowed cross site request forgery, making
it possible to delete all private messages of a user by sending
them to a crafted web page.

CVE-2006-6841 / CVE-2006-6508

Cross site request forgery enabled an attacker to perform various
actions on behalf of a logged in user. (Applies to sarge only)

CVE-2006-6840

A negative start parameter could allow an attacker to create
invalid output. (Applies to sarge only)

CVE-2006-6839

Redirection targets were not fully checked, leaving room for
unauthorised external redirections via a phpBB forum.
(Applies to sarge only)

CVE-2006-4758

An authenticated forum administrator may upload files of any
type by using specially crafted filenames. (Applies to sarge only)


For the stable distribution (etch), these problems have been fixed
in version 2.0.21-7.

For the old stable distribution (sarge), these problems have been
fixed in version 2.0.13+1-6sarge4.

For the unstable distribution (sid) these problems have been fixed
in version 2.0.22-3.

We recommend that you upgrade your phpbb2 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201488-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1488-1 (phpbb2)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"phpbb2-conf-mysql", ver:"2.0.13-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpbb2", ver:"2.0.13-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpbb2-languages", ver:"2.0.13-6sarge4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpbb2-languages", ver:"2.0.21-7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpbb2", ver:"2.0.21-7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"phpbb2-conf-mysql", ver:"2.0.21-7", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
