# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1489-1 (iceweasel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60364);
 script_cve_id("CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0414", "CVE-2008-0415", "CVE-2008-0416", "CVE-2008-0417", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593", "CVE-2008-0594");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1489-1 (iceweasel)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to iceweasel
announced via advisory DSA 1489-1.

Several remote vulnerabilities have been discovered in the Iceweasel
web browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2008-0412

Jesse Ruderman, Kai Engert, Martijn Wargers, Mats Palmgren and Paul
Nickerson discovered crashes in the layout engine, which might allow
the execution of arbitrary code.

CVE-2008-0413

Carsten Book, Wesley Garland, Igor Bukanov, moz_bug_r_a4, shutdown,
Philip Taylor and tgirmann discovered crashes in the Javascript
engine, which might allow the execution of arbitrary code.

CVE-2008-0414

hong and Gregory Fleisher discovered that file input focus
vulnerabilities in the file upload control could allow information
disclosure of local files.

CVE-2008-0415

moz_bug_r_a4 and Boris Zbarsky discovered discovered several
vulnerabilities in Javascript handling, which could allow
privilege escalation.

CVE-2008-0417

Justin Dolske discovered that the password storage machanism could
be abused by malicious web sites to corrupt existing saved passwords.

CVE-2008-0418

Gerry Eisenhaur and moz_bug_r_a4 discovered that a directory
traversal vulnerability in chrome: URI handling could lead to
information disclosure.

CVE-2008-0419

David Bloom discovered a race condition in the image handling of
designMode elements, which can lead to information disclosure or
potentially the execution of arbitrary code.

CVE-2008-0591

Michal Zalewski discovered that timers protecting security-sensitive
dialogs (which disable dialog elements until a timeout is reached)
could be bypassed by window focus changes through Javascript.

CVE-2008-0592

It was discovered that malformed content declarations of saved
attachments could prevent a user in the opening local files
with a .txt file name, resulting in minor denial of service.

CVE-2008-0593

Martin Straka discovered that insecure stylesheet handling during
redirects could lead to information disclosure.

CVE-2008-0594

Emil Ljungdahl and Lars-Olof Moilanen discovered that phishing
protections could be bypassed with <div> elements.


For the stable distribution (etch), these problems have been fixed in
version 2.0.0.12-0etch1.

The Mozilla products from the old stable distribution (sarge) are no
longer supported with security updates.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201489-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1489-1 (iceweasel)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.12-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
