# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1562-1 (iceape)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60867);
 script_cve_id("CVE-2008-1380");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1562-1 (iceape)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to iceape
announced via advisory DSA 1562-1.

It was discovered that crashes in the Javascript engine of Iceape,
an unbranded version of the Seamonkey internet suite could
potentially lead to the execution of arbitrary code.

For the stable distribution (etch), this problem has been fixed in
version 1.0.13~pre080323b-0etch3.

For the unstable distribution (sid), this problem has been fixed in
version 1.1.9-2.

We recommend that you upgrade your iceape packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201562-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1562-1 (iceape)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mozilla-calendar", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dom-inspector", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-dev", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-chatzilla", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dev", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-browser", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-js-debugger", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-chatzilla", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-psm", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-mailnews", ver:"1.8+1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-mailnews", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-gnome-support", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dbg", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-browser", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-calendar", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceape-dom-inspector", ver:"1.0.13~pre080323b-0etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
