# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1640-1 (python-django)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61642);
 script_cve_id("CVE-2008-3909", "CVE-2007-5712");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 1640-1 (python-django)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to python-django
announced via advisory DSA 1640-1.

Simon Willison discovered that in Django, a Python web framework, the
feature to retain HTTP POST data during user reauthentication allowed
a remote attacker to perform unauthorized modification of data through
cross site request forgery. The is possible regardless of the Django
plugin to prevent cross site request forgery being enabled. The Common
Vulnerabilities and Exposures project identifies this issue as
CVE-2008-3909.

In this update the affected feature is disabled; this is in accordance
with upstream's preferred solution for this situation.

This update takes the opportunity to also include a relatively minor
denial of service attack in the internationalisaton framework, known
as CVE-2007-5712.

For the stable distribution (etch), these problems have been fixed in
version 0.95.1-1etch2.

For the unstable distribution (sid), these problems have been fixed in
version 1.0-1.

We recommend that you upgrade your python-django package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201640-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 1640-1 (python-django)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"python-django", ver:"0.95.1-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
