# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 203-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53446);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 203-1 (smb2www)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to smb2www
announced via advisory DSA 203-1.

Robert Luberda found a security problem in smb2www, a Windows Network
client that is accessible through a web browser.  This could lead a
remote attacker to execute arbitrary programs under the user id
www-data on the host where smb2www is running.

This problem has been fixed in version 980804-16.1 for the current
stable distribution (woody), in version 980804-8.1 of the old stable
distribution (potato) and in version 980804-17 for the unstable
distribution (sid).

We recommend that you upgrade your smb2www package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20203-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 203-1 (smb2www)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"smb2www", ver:"980804-8.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smb2www", ver:"980804-16.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
