# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 225-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53306);
 script_cve_id("CVE-2002-1394", "CVE-2002-1148");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 225-1 (tomcat4)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to tomcat4
announced via advisory DSA 225-1.

A security vulnerability has been confirmed to exist in Apache Tomcat
4.0.x releases, which allows to use a specially crafted URL to return
the unprocessed source of a JSP page, or, under special circumstances,
a static resource which would otherwise have been protected by a
security constraint, without the need for being properly
authenticated.  This is based on a variant of the exploit that was
identified as CVE-2002-1148.

For the current stable distribution (woody) this problem has been
fixed in version 4.0.3-3woody2.

The old stable distribution (potato) does not contain tomcat packages.

For the unstable distribution (sid) this problem does not exist in the
current version 4.1.16-1.

We recommend that you upgrade your tomcat packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20225-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 225-1 (tomcat4)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libtomcat4-java", ver:"4.0.3-3woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat4-webapps", ver:"4.0.3-3woody2", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tomcat4", ver:"4.0.3-3woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
