# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 267-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53358);
 script_bugtraq_id(7025);
 script_cve_id("CVE-2003-0144");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 267-2 (lpr)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to lpr
announced via advisory DSA 267-2.

The correction for CVE-2003-0144 for the old stable distribution
(potato) was a little bit too strict apparently and this update
corrects this.  For completeness here is the advisory text:

A buffer overflow has been discovered in lpr, a BSD lpr/lpd line
printer spooling system.  This problem can be exploited by a local
user to gain root privileges, even if the printer system is set up
properly.

For the stable distribution (woody) this problem has been fixed in
version 2000.05.07-4.3.

For the old stable distribution (potato) this problem has been fixed
in version 0.48-1.2.

For the stable distribution (sid) this problem has been fixed in
version 2000.05.07-4.20.

We recommend that you upgrade your lpr package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20267-2

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 267-2 (lpr)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lpr", ver:"0.48-1.2", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
