# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 281-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53350);
 script_bugtraq_id(6921);
 script_cve_id("CVE-2003-0203");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 281-1 (moxftp)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to moxftp
announced via advisory DSA 281-1.

Knud Erik Hjgaard discovered a vulnerability in moxftp (and xftp
respectively), an Athena X interface to FTP.  Insufficient bounds
checking could lead to execution of arbitrary code, provided by a
malicious FTP server.   Erik Tews fixed this.

For the stable distribution (woody) this problem has been fixed in
version 2.2-18.1.

For the old stable distribution (potato) this problem has been fixed
in version 2.2-13.1.

For the unstable distribution (sid) this problem has been fixed
in version 2.2-18.20.

We recommend that you upgrade your xftp package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20281-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 281-1 (moxftp)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xftp", ver:"2.2-13.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xftp", ver:"2.2-18.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
