# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 472-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53169);
 script_bugtraq_id(10041);
 script_cve_id("CVE-2003-0648");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 472-1 (fte)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to fte
announced via advisory DSA 472-1.

Steve Kemp and Jaguar discovered a number of buffer overflow
vulnerabilities in vfte, a version of the fte editor which runs on the
Linux console, found in the package fte-console.  This program is
setuid root in order to perform certain types of low-level operations
on the console.

Due to these bugs, setuid privilege has been removed from vfte, making
it only usable by root.  We recommend using the terminal version (in
the fte-terminal package) instead, which runs on any capable terminal
including the Linux console.

For the stable distribution (woody) these problems have been fixed in
version 0.49.13-15woody1.

For the unstable distribution (sid) these problems have been fixed in
version 0.50.0-1.1.

We recommend that you update your fte package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20472-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 472-1 (fte)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fte", ver:"0.49.13-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fte-console", ver:"0.49.13-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fte-docs", ver:"0.49.13-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fte-terminal", ver:"0.49.13-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fte-xwindow", ver:"0.49.13-15woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
