# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 762-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54384);
 script_cve_id("CVE-2005-2250", "CVE-2005-2277");
 script_bugtraq_id(14230);
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 762-1 (affix)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to affix
announced via advisory DSA 762-1.

Kevin Finisterre discovered two problems in the Bluetooth FTP client
from affix, user space utilities for the Affix Bluetooth protocol
stack.  The Common Vulnerabilities and Exposures project identifies
the following vulnerabilities:

CVE-2005-2250

A buffer overflow allows remote attackers to execute arbitrary
code via a long filename in an OBEX file share.

CVE-2005-2277

Missing input sanitising before executing shell commands allow an
attacker to execute arbitrary commands as root.

The old stable distribution (woody) is not affected by these problems.

For the stable distribution (sarge) these problems have been fixed in
version 2.1.1-2.

For the unstable distribution (sid) these problems have been fixed in
version 2.1.2-2.

We recommend that you upgrade your affix package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20762-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 762-1 (affix)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"affix", ver:"2.1.1-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaffix-dev", ver:"2.1.1-2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaffix2", ver:"2.1.1-2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
