# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 877-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55754);
 script_cve_id("CVE-2005-3122", "CVE-2005-3123");
 script_version ("$");
 name["english"] = "Debian Security Advisory DSA 877-1 (gnump3d)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to gnump3d
announced via advisory DSA 877-1.

Steve Kemp discovered two vulnerabilities in gnump3d, a streaming
server for MP3 and OGG files.  The Common Vulnerabilities and
Exposures Project identifies the following problems:

CVE-2005-3122
The 404 error page does not strip malicious javascript content
from the resulting page, which would be executed in the victims
browser.

CVE-2005-3123
By using specially crafting URLs it is possible to read arbitary
files to which the user of the streaming server has access to.

The old stable distribution (woody) does not contain a gnump3d package.

For the stable distribution (sarge) these problems have been fixed in
version 2.9.3-1sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 2.9.6-1.

We recommend that you upgrade your gnump3d package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20877-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Debian Security Advisory DSA 877-1 (gnump3d)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securiytspace.com");
 family["english"] = "Debian Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gnump3d", ver:"2.9.3-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
