###############################################################################
# OpenVAS Vulnerability Test
# $Id: deluxeBB_1_3.nasl 2858 2009-03-20 10:01:53Z mime $
#
# DeluxeBB 'misc.php' SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if (description)
{
 script_id(100064);
 script_bugtraq_id(34174);
 script_version ("1.0");

 script_name(english:"DeluxeBB 'misc.php' SQL Injection Vulnerability");
 desc["english"] = "

 Overview:
  DeluxeBB is prone to an SQL-injection vulnerability because it fails
  to sufficiently sanitize user-supplied data before using it in an
  SQL query.

  Exploiting this issue could allow an attacker to compromise the
  application, access or modify data, or exploit latent
  vulnerabilities in the underlying database.

  DeluxeBB 1.3 and earlier versions are vulnerable. 

 See also;
  http://www.securityfocus.com/bid/34174
  http://www.deluxebb.com/

 Solution:
  Upgrade to newer Version if available.
  

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if DeluxeBB <= 1.3 is vulnerable to SQL Injection");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Web application abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencies("deluxeBB_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);

install = get_kb_item(string("www/", port, "/deluxeBB"));
if (isnull(install)) exit(0);

matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");

if (!isnull(matches[1])) {
	version = matches[1];
	if(version != "unknown") { 
	  if (version_is_less_equal(version:version, test_version:"1.3") ) { 
	     security_warning(port);
	     exit(0);
	  }
	} else {

	 if(!isnull(matches[2])) {

	   dir = matches[2];
	   url = string(dir, "/misc.php?sub=memberlist&order=1&qorder=UNION+ALL+SELECT+1,2,3,4,5,6,7,8,9,10,11,12,13,14,0x4f70656e5641532d53514c2d496e6a656374696f6e2d54657374,16,17,18,19,20,21,22,23,24,25,26,27,28,29%23&sort=ASC&filter=all&searchuser=.&submit=1");
	   req = http_get(item:url, port:port);
           buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);  
	   if( buf == NULL )exit(0);
	  
	   if(egrep(pattern: "OpenVAS-SQL-Injection-Test", string: buf)) {

	     security_warning(port:port);
	     exit(0);

	   }  
	 }
      }	  
}

exit(0);
