# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0268 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63140);
 script_cve_id("CVE-2009-0022", "CVE-2008-4314", "CVE-2008-3789", "CVE-2008-1105");
 script_version ("$");
 name["english"] = "Fedora Core 9 FEDORA-2009-0268 (samba)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to samba
announced via advisory FEDORA-2009-0268.

Update Information:

Security fix for CVE-2009-0022

ChangeLog:

* Mon Jan  5 2009 Guenther Deschner  - 3.2.7-0.23
- Update to 3.2.7 (Security fix for CVE-2009-0022)
* Thu Nov 27 2008 Guenther Deschner  - 3.2.5-0.22
- Update to 3.2.5 (Security fix for CVE-2008-4314)

References:

[ 1 ] Bug #479110 - CVE-2009-0022 samba: potential access to / in setups with registry shares enabled
https://bugzilla.redhat.com/show_bug.cgi?id=479110

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update samba' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0268

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 9 FEDORA-2009-0268 (samba)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc", rpm:"libtalloc~1.2.0~23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~1.2.0~23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb", rpm:"libtdb~1.1.1~23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~1.1.1~23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-domainjoin-gui", rpm:"samba-domainjoin-gui~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind-devel", rpm:"samba-winbind-devel~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tdb-tools", rpm:"tdb-tools~1.1.1~23.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.2.7~0.23.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
