# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3820 (xpdf)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63879);
 script_cve_id("CVE-2009-0799", "CVE-2009-0800", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183", "CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0166");
 script_version ("$");
 name["english"] = "Fedora Core 10 FEDORA-2009-3820 (xpdf)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to xpdf
announced via advisory FEDORA-2009-3820.

Update Information:

Fix several security updates in xpdf (3.02pl3 patch applied).
ChangeLog:

* Thu Apr 16 2009 Tom spot Callaway  - 1:3.02-13
- apply xpdf-3.02pl3 security patch to fix:
CVE-2009-0799, CVE-2009-0800, CVE-2009-1179, CVE-2009-1180
CVE-2009-1181, CVE-2009-1182, CVE-2009-1183

References:

[ 1 ] Bug #495886 - CVE-2009-0799 PDF JBIG2 decoder OOB read
https://bugzilla.redhat.com/show_bug.cgi?id=495886
[ 2 ] Bug #495887 - CVE-2009-0800 PDF JBIG2 multiple input validation flaws
https://bugzilla.redhat.com/show_bug.cgi?id=495887
[ 3 ] Bug #495889 - CVE-2009-1179 PDF JBIG2 integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=495889
[ 4 ] Bug #495892 - CVE-2009-1180 PDF JBIG2 invalid free()
https://bugzilla.redhat.com/show_bug.cgi?id=495892
[ 5 ] Bug #495894 - CVE-2009-1181 PDF JBIG2 NULL dereference
https://bugzilla.redhat.com/show_bug.cgi?id=495894
[ 6 ] Bug #495896 - CVE-2009-1182 PDF JBIG2 MMR decoder buffer overflows
https://bugzilla.redhat.com/show_bug.cgi?id=495896
[ 7 ] Bug #495899 - CVE-2009-1183 PDF JBIG2 MMR infinite loop DoS
https://bugzilla.redhat.com/show_bug.cgi?id=495899
[ 8 ] Bug #490612 - CVE-2009-0146 xpdf: Multiple buffer overflows in JBIG2 decoder (setBitmap, readSymbolDictSeg)
https://bugzilla.redhat.com/show_bug.cgi?id=490612
[ 9 ] Bug #490614 - CVE-2009-0147 xpdf: Multiple integer overflows in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490614
[ 10 ] Bug #490625 - CVE-2009-0166 xpdf: Freeing of potentially uninitialized memory in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490625

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xpdf' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3820

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Fedora Core 10 FEDORA-2009-3820 (xpdf)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Fedora Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~13.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-debuginfo", rpm:"xpdf-debuginfo~3.02~13.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
