#
#VID 197f444f-e8ef-11d9-b875-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53972);
 script_cve_id("CVE-2005-0953", "CVE-2005-1260");
 script_version ("$");
 name["english"] = "FreeBSD Ports: bzip2";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bzip2

CVE-2005-0953
Race condition in bzip2 1.0.2 and earlier allows local users to modify
permissions of arbitrary files via a hard link attack on a file while
it is being decompressed, whose permissions are changed by bzip2 after
the decompression is complete.

CVE-2005-1260
bzip2 allows remote attackers to cause a denial of service (hard drive
consumption) via a crafted bzip2 file that causes an infinite loop
(a.k.a 'decompression bomb').

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: bzip2";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bzip2");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.3_1")<0) {
    security_note(0, data:"Package bzip2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
