#
#VID 24b64fb0-af1d-11dd-8a16-001b1116b350
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 24b64fb0-af1d-11dd-8a16-001b1116b350
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61877);
 script_cve_id("CVE-2008-5050");
 script_version ("$");
 name["english"] = "FreeBSD Ports: clamav";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   clamav
   clamav-devel

CVE-2008-5050
Off-by-one error in the get_unicode_name function
(libclamav/vba_extract.c) in Clam Anti-Virus (ClamAV) before 0.94.1
allows remote attackers to cause a denial of service (crash) or
possibly execute arbitrary code via a crafted VBA project file, which
triggers a heap-based buffer overflow.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.securityfocus.com/archive/1/498169/30/0/threaded
http://svn.clamav.net/svn/clamav-devel/trunk/ChangeLog
http://www.vuxml.org/freebsd/24b64fb0-af1d-11dd-8a16-001b1116b350.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: clamav";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"clamav");
if(!isnull(bver) && revcomp(a:bver, b:"0.94.1")<0) {
    security_note(0, data:"Package clamav version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"clamav-devel");
if(!isnull(bver) && revcomp(a:bver, b:"20081105")<0) {
    security_note(0, data:"Package clamav-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
