#
#VID 96df5fd0-8900-11d9-aa18-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52171);
 script_cve_id("CVE-2005-0490");
 script_bugtraq_id(12615,12616);
 script_version ("$");
 name["english"] = "FreeBSD Ports: curl";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: curl

CVE-2005-0490
Multiple stack-based buffer overflows in libcURL and cURL 7.12.1, and
possibly other versions, allow remote malicious web servers to execute
arbitrary code via base64 encoded replies that exceed the intended
buffer lengths when decoded, which is not properly handled by (1) the
Curl_input_ntlm function in http_ntlm.c during NTLM authentication or
(2) the Curl_krb_kauth and krb4_auth functions in krb4.c during
Kerberos authentication.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=110902850731457
http://marc.theaimsgroup.com/?l=bugtraq&m=110902601221592
http://www.vuxml.org/freebsd/96df5fd0-8900-11d9-aa18-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: curl";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"curl");
if(!isnull(bver) && revcomp(a:bver, b:"7.13.1")<0) {
    security_note(0, data:"Package curl version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
