#
#VID 60e1792b-c380-11dc-821a-000bcdc1757a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60186);
 script_cve_id("CVE-2006-3756");
 script_version ("$");
 name["english"] = "FreeBSD Ports: geeklog";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: geeklog

CVE-2006-3756
Cross-site scripting (XSS) vulnerability in Geeklog 1.4.0sr4 and
earlier, and 1.3.11sr6 and earlier, allows remote attackers to inject
arbitrary web script or HTML via unspecified vectors when validating
comments in (1) lib-comment.php (1.4.0sr4) or (2) comment.php
(0.3.11sr6).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.geeklog.net/article.php/geeklog-1.4.0sr6
http://www.vuxml.org/freebsd/60e1792b-c380-11dc-821a-000bcdc1757a.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: geeklog";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"geeklog");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.1")<0) {
    security_note(0, data:"Package geeklog version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
