#
#VID 116b0820-d59c-11da-8098-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56651);
 script_bugtraq_id(16187);
 script_cve_id("CVE-2006-0146");
 script_version ("$");
 name["english"] = "FreeBSD Ports: lifetype";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: lifetype

CVE-2006-0146
The server.php test script in ADOdb for PHP before 4.70, as used in
multiple products including (1) Mantis, (2) PostNuke, (3) Moodle, and
(4) Cacti, (5) Xaraya, (6) PHPOpenChat, and (7) MAXdev MD-Pro, and
when the MySQL root password is empty, allows remote attackers to
execute arbitrary SQL statements via the sql parameter.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/19699/
http://secunia.com/advisories/17418/
http://www.vuxml.org/freebsd/116b0820-d59c-11da-8098-00123ffe8333.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: lifetype";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"lifetype");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.3")<0) {
    security_note(0, data:"Package lifetype version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
