#
#VID 0dccaa28-7f3c-11dd-8de5-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 0dccaa28-7f3c-11dd-8de5-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61617);
 script_cve_id("CVE-2008-2315", "CVE-2008-2316", "CVE-2008-3142", "CVE-2008-3144");
 script_version ("$");
 name["english"] = "FreeBSD Ports: python24";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   python24
   python25
   python23

CVE-2008-2315
Multiple integer overflows in Python 2.5.2 and earlier allow
context-dependent attackers to have an unknown impact via vectors
related to the (1) stringobject, (2) unicodeobject, (3) bufferobject,
(4) longobject, (5) tupleobject, (6) stropmodule, (7) gcmodule, and
(8) mmapmodule modules.
CVE-2008-2316
Integer overflow in _hashopenssl.c in the hashlib module in Python
2.5.2 and earlier might allow context-dependent attackers to defeat
cryptographic digests, related to 'partial hashlib hashing of data
exceeding 4GB.'
CVE-2008-3142
Multiple buffer overflows in Python 2.5.2 and earlier on 32bit
platforms allow context-dependent attackers to cause a denial of
service (crash) or have unspecified other impact via a long string
that leads to incorrect memory allocation during Unicode string
processing, related to the unicode_resize function and the
PyMem_RESIZE macro.
CVE-2008-3144
Multiple integer overflows in the PyOS_vsnprintf function in
Python/mysnprintf.c in Python 2.5.2 and earlier allow
context-dependent attackers to cause a denial of service (memory
corruption) or have unspecified other impact via crafted input to
string formatting operations.  NOTE: the handling of certain integer
values is also affected by related integer underflows and an
off-by-one error.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.python.org/issue2620
http://bugs.python.org/issue2588
http://bugs.python.org/issue2589
http://secunia.com/advisories/31305
http://mail.python.org/pipermail/python-checkins/2008-July/072276.html
http://mail.python.org/pipermail/python-checkins/2008-July/072174.html
http://mail.python.org/pipermail/python-checkins/2008-June/070481.html
http://www.vuxml.org/freebsd/0dccaa28-7f3c-11dd-8de5-0030843d3802.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: python24";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"python24");
if(!isnull(bver) && revcomp(a:bver, b:"2.4.5_2")<0) {
    security_note(0, data:"Package python24 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"python25");
if(!isnull(bver) && revcomp(a:bver, b:"2.5.2_3")<0) {
    security_note(0, data:"Package python25 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"python23");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package python23 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
