#
#VID f14ad681-5b88-11dc-812d-0011098b2f36
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58806);
 script_cve_id("CVE-2005-1270");
 script_bugtraq_id(13399);
 script_version ("$");
 name["english"] = "FreeBSD Ports: rkhunter";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: rkhunter

CVE-2005-1270
The (1) check_update.sh and (2) rkhunter script in Rootkit Hunter
before 1.2.3-r1 create temporary files with predictable file names,
which allows local users to overwrite arbitrary files via a symlink
attack.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.gentoo.org/security/en/glsa/glsa-200504-25.xml
http://www.vuxml.org/freebsd/f14ad681-5b88-11dc-812d-0011098b2f36.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: rkhunter";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"rkhunter");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.5")<0) {
    security_note(0, data:"Package rkhunter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
