#
#VID 06f142ff-4df3-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52277);
 script_cve_id("CVE-2004-1487", "CVE-2004-1488");
 script_bugtraq_id(11871);
 script_version ("$");
 name["english"] = "FreeBSD Ports: wget, wget-devel";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   wget
   wget-devel
   wgetpro
   wget+ipv6

CVE-2004-1487
wget 1.8.x and 1.9.x allows a remote malicious web server to overwrite
certain files via a redirection URL containing a '..' that resolves to
the IP address of the malicious server, which bypasses wget's
filtering for '..' sequences.

CVE-2004-1488
wget 1.8.x and 1.9.x does not filter or quote control characters when
displaying HTTP responses to the terminal, which may allow remote
malicious web servers to inject terminal escape sequences and execute
arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/261755
http://marc.theaimsgroup.com/?l=bugtraq&m=110269474112384
http://www.vuxml.org/freebsd/06f142ff-4df3-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "FreeBSD Ports: wget, wget-devel";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wget");
if(!isnull(bver) && revcomp(a:bver, b:"1.10.a1")<0) {
    security_note(0, data:"Package wget version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wget-devel");
if(!isnull(bver) && revcomp(a:bver, b:"1.10.a1")<0) {
    security_note(0, data:"Package wget-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wgetpro");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package wgetpro version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"wget+ipv6");
if(!isnull(bver) && revcomp(a:bver, b:"0")>=0) {
    security_note(0, data:"Package wget+ipv6 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
