###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# FTPDMIN 'RNFR' Command Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100132);
 script_bugtraq_id(34479);
 script_version ("1.0");

 script_name(english:"FTPDMIN 'RNFR' Command Buffer Overflow Vulnerability");  

 desc["english"] = "

 Overview:
  According to its version number, the remote version of Ftpdmin is
  prone to a buffer-overflow vulnerability.

  A successful exploit may allow attackers to execute arbitrary code
  in the context of the vulnerable service. Failed exploit attempts
  will likely cause denial-of-service conditions.

 See also:
  http://www.securityfocus.com/bid/34479

 Risk factor : High";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if FTPDMIN is vulnerable to Command Buffer Overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english:"FTP");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("ftpdmin_detect.nasl");
 script_require_ports("Services/ftp", 21);
 exit(0);
}

include("ftp_func.inc");
include("version_func.inc");

ftpPort = get_kb_item("Services/ftp");
if(!ftpPort){
    exit(0);
}

if(!get_port_state(ftpPort)){
    exit(0);
}

if(!version = get_kb_item("ftpdmin/Ver"))exit(0);
 if(version_is_equal(version: version, test_version: "0.96")) {

     security_hole(port:ftpPort);
     exit(0);

 }  

exit(0);
