###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for cups CESA-2008:0498 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880189);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0498");
  script_cve_id("CVE-2008-1722");
  script_name(english: "CentOS Update for cups CESA-2008:0498 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  The Common UNIX Printing System (CUPS) provides a portable printing layer
  for UNIX operating systems.
  
  An integer overflow flaw leading to a heap buffer overflow was discovered
  in the Portable Network Graphics (PNG) decoding routines used by the CUPS
  image converting filters &quot;imagetops&quot; and &quot;imagetoraster&quot;. An attacker could
  create a malicious PNG file that could possibly execute arbitrary code as
  the &quot;lp&quot; user if the file was printed. (CVE-2008-1722)
  
  All CUPS users are advised to upgrade to these updated packages, which
  contain backported patch to resolve this issue.


  Affected Software/OS:
  cups on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-June/014960.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cups");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"cups", rpm:"cups~1.1.17~13.3.53", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.1.17~13.3.53", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.1.17~13.3.53", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}