###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for net-snmp CESA-2008:0529 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880234);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0529");
  script_cve_id("CVE-2008-2292", "CVE-2008-0960");
  script_name(english: "CentOS Update for net-snmp CESA-2008:0529 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  The Simple Network Management Protocol (SNMP) is a protocol used for
  network management.
  
  A flaw was found in the way Net-SNMP checked an SNMPv3 packet's Keyed-Hash
  Message Authentication Code (HMAC). An attacker could use this flaw to
  spoof an authenticated SNMPv3 packet. (CVE-2008-0960)
  
  A buffer overflow was found in the Perl bindings for Net-SNMP. This could
  be exploited if an attacker could convince an application using the
  Net-SNMP Perl module to connect to a malicious SNMP agent. (CVE-2008-2292)
  
  All users of net-snmp should upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  net-snmp on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-June/014970.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of net-snmp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.0.9~2.30E.24", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-devel", rpm:"net-snmp-devel~5.0.9~2.30E.24", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-libs", rpm:"net-snmp-libs~5.0.9~2.30E.24", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-perl", rpm:"net-snmp-perl~5.0.9~2.30E.24", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"net-snmp-utils", rpm:"net-snmp-utils~5.0.9~2.30E.24", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}