###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for openoffice.org CESA-2008:0538 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880178);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0538");
  script_cve_id("CVE-2008-2152", "CVE-2008-2366");
  script_name(english: "CentOS Update for openoffice.org CESA-2008:0538 centos4 x86_64");
  desc["english"] = "

  Vulnerability Insight:
  OpenOffice.org is an office productivity suite that includes desktop
  applications such as a word processor, spreadsheet, presentation manager,
  formula editor, and drawing program.
  
  Sean Larsson found a heap overflow flaw in the OpenOffice memory allocator.
  If a carefully crafted file was opened by a victim, an attacker could use
  the flaw to crash OpenOffice.org or, possibly, execute arbitrary code.
  (CVE-2008-2152)
  
  It was discovered that certain libraries in the Red Hat Enterprise Linux 3
  and 4 openoffice.org packages had an insecure relative RPATH (runtime
  library search path) set in the ELF (Executable and Linking Format) header.
  A local user able to convince another user to run OpenOffice in an
  attacker-controlled directory, could run arbitrary code with the privileges
  of the victim. (CVE-2008-2366)
  
  All users of openoffice.org are advised to upgrade to these updated
  packages, which contain backported fixes which correct these issues.


  Affected Software/OS:
  openoffice.org on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-June/015047.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openoffice.org");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS4")
{

  if(isrpmvuln(pkg:"openoffice.org", rpm:"openoffice.org~1.1.5~10.6.0.5.EL4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openoffice.org-i18n", rpm:"openoffice.org-i18n~1.1.5~10.6.0.5.EL4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openoffice.org-kde", rpm:"openoffice.org-kde~1.1.5~10.6.0.5.EL4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openoffice.org-libs", rpm:"openoffice.org-libs~1.1.5~10.6.0.5.EL4", rls:"CENTOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}