###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for ipsec-tools CESA-2008:0849 centos3 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880133);
  script_version("$Revision: 1.0 $");
  script_xref(name: "CESA", value: "2008:0849");
  script_cve_id("CVE-2008-3651", "CVE-2008-3652");
  script_name(english: "CentOS Update for ipsec-tools CESA-2008:0849 centos3 i386");
  desc["english"] = "

  Vulnerability Insight:
  The ipsec-tools package is used in conjunction with the IPsec functionality
  in the Linux kernel and includes racoon, an IKEv1 keying daemon.
  
  Two denial of service flaws were found in the ipsec-tools racoon daemon. It
  was possible for a remote attacker to cause the racoon daemon to consume
  all available memory. (CVE-2008-3651, CVE-2008-3652)
  
  Users of ipsec-tools should upgrade to this updated package, which contains
  backported patches that resolve these issues.


  Affected Software/OS:
  ipsec-tools on CentOS 3

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2008-August/015207.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ipsec-tools");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CENTOS3")
{

  if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.2.5~0.7.rhel3.5", rls:"CENTOS3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}