###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for libXfont RHSA-2008:0064-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870025);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0064-01");
  script_cve_id("CVE-2008-0006");
  script_name(english: "RedHat Update for libXfont RHSA-2008:0064-01");
  desc["english"] = "

  Vulnerability Insight:
  The libXfont package contains the X.Org X11 libXfont runtime library.
  
  A heap based buffer overflow flaw was found in the way the X.Org server
  handled malformed font files. A malicious local user could exploit this
  issue to potentially execute arbitrary code with the privileges of the
  X.Org server. (CVE-2008-0006)
  
  Users of X.Org libXfont should upgrade to these updated packages, which
  contain a backported patch to resolve this issue.


  Affected Software/OS:
  libXfont on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00012.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libXfont");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"libXfont", rpm:"libXfont~1.2.2~1.0.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libXfont-debuginfo", rpm:"libXfont-debuginfo~1.2.2~1.0.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libXfont-devel", rpm:"libXfont-devel~1.2.2~1.0.3.el5_1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}