###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for icu RHSA-2008:0090-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870004);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0090-01");
  script_cve_id("CVE-2007-4770", "CVE-2007-4771");
  script_name(english: "RedHat Update for icu RHSA-2008:0090-01");
  desc["english"] = "

  Vulnerability Insight:
  The International Components for Unicode (ICU) library provides robust and
  full-featured Unicode services.
  
  Will Drewry reported multiple flaws in the way libicu processed certain
  malformed regular expressions. If an application linked against ICU, such
  as OpenOffice.org, processed a carefully crafted regular expression, it may
  be possible to execute arbitrary code as the user running the application.
  (CVE-2007-4770, CVE-2007-4771)
  
  All users of icu should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  icu on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-January/msg00018.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of icu");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"icu", rpm:"icu~3.6~5.11.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"icu-debuginfo", rpm:"icu-debuginfo~3.6~5.11.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libicu", rpm:"libicu~3.6~5.11.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libicu-devel", rpm:"libicu-devel~3.6~5.11.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libicu-doc", rpm:"libicu-doc~3.6~5.11.1", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}