###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for thunderbird RHSA-2008:0105-02
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870044);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0105-02");
  script_cve_id("CVE-2008-0304", "CVE-2008-0412", "CVE-2008-0413", "CVE-2008-0415", "CVE-2008-0418", "CVE-2008-0419", "CVE-2008-0420", "CVE-2008-0591", "CVE-2008-0592", "CVE-2008-0593");
  script_name(english: "RedHat Update for thunderbird RHSA-2008:0105-02");
  desc["english"] = "

  Vulnerability Insight:
  Mozilla Thunderbird is a standalone mail and newsgroup client.
  
  A heap-based buffer overflow flaw was found in the way Thunderbird
  processed messages with external-body Multipurpose Internet Message
  Extensions (MIME) types. A HTML mail message containing malicious content
  could cause Thunderbird to execute arbitrary code as the user running
  Thunderbird. (CVE-2008-0304)
  
  Several flaws were found in the way Thunderbird processed certain malformed
  HTML mail content. A HTML mail message containing malicious content could
  cause Thunderbird to crash, or potentially execute arbitrary code as the
  user running Thunderbird. (CVE-2008-0412, CVE-2008-0413, CVE-2008-0415,
  CVE-2008-0419)
  
  Several flaws were found in the way Thunderbird displayed malformed HTML
  mail content. A HTML mail message containing specially-crafted content
  could trick a user into surrendering sensitive information. (CVE-2008-0420,
  CVE-2008-0591, CVE-2008-0593)
  
  A flaw was found in the way Thunderbird handles certain chrome URLs. If a
  user has certain extensions installed, it could allow a malicious HTML mail
  message to steal sensitive session data. Note: this flaw does not affect a
  default installation of Thunderbird. (CVE-2008-0418)
  
  Note: JavaScript support is disabled by default in Thunderbird; the above
  issues are not exploitable unless JavaScript is enabled.
  
  A flaw was found in the way Thunderbird saves certain text files. If a
  remote site offers a file of type &quot;plain/text&quot;, rather than &quot;text/plain&quot;,
  Thunderbird will not show future &quot;text/plain&quot; content to the user, forcing
  them to save those files locally to view the content. (CVE-2008-0592)
  
  Users of thunderbird are advised to upgrade to these updated packages,
  which contain backported patches to resolve these issues.


  Affected Software/OS:
  thunderbird on Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-February/msg00020.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"thunderbird", rpm:"thunderbird~1.5.0.12~8.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"thunderbird-debuginfo", rpm:"thunderbird-debuginfo~1.5.0.12~8.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}