###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for mysql RHSA-2008:0364-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870069);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0364-01");
  script_cve_id("CVE-2006-0903", "CVE-2006-4031", "CVE-2006-4227", "CVE-2006-7232", "CVE-2007-1420", "CVE-2007-2583", "CVE-2007-2691", "CVE-2007-2692", "CVE-2007-3781", "CVE-2007-3782");
  script_name(english: "RedHat Update for mysql RHSA-2008:0364-01");
  desc["english"] = "

  Vulnerability Insight:
  MySQL is a multi-user, multi-threaded SQL database server. MySQL is a
  client/server implementation consisting of a server daemon (mysqld), and
  many different client programs and libraries.
  
  MySQL did not require privileges such as &quot;SELECT&quot; for the source table in a
  &quot;CREATE TABLE LIKE&quot; statement. An authenticated user could obtain sensitive
  information, such as the table structure. (CVE-2007-3781)
  
  A flaw was discovered in MySQL that allowed an authenticated user to gain
  update privileges for a table in another database, via a view that refers
  to the external table. (CVE-2007-3782)
  
  MySQL did not require the &quot;DROP&quot; privilege for &quot;RENAME TABLE&quot; statements.
  An authenticated user could use this flaw to rename arbitrary tables.
  (CVE-2007-2691)
  
  A flaw was discovered in the mysql_change_db function when returning from
  SQL SECURITY INVOKER stored routines. An authenticated user could use this
  flaw to gain database privileges. (CVE-2007-2692)
  
  MySQL allowed an authenticated user to bypass logging mechanisms via SQL
  queries that contain the NULL character, which were not properly handled by
  the mysql_real_query function. (CVE-2006-0903)
  
  MySQL allowed an authenticated user to access a table through a previously
  created MERGE table, even after the user's privileges were revoked from
  the original table, which might violate intended security policy. This is
  addressed by allowing the MERGE storage engine to be disabled, which can
  be done by running mysqld with the &quot;--skip-merge&quot; option. (CVE-2006-4031)
  
  MySQL evaluated arguments in the wrong security context, which allowed an
  authenticated user to gain privileges through a routine that had been made
  available using &quot;GRANT EXECUTE&quot;. (CVE-2006-4227)
  
  Multiple flaws in MySQL allowed an authenticated user to cause the MySQL
  daemon to crash via crafted SQL queries. This only caused a temporary
  denial of service, as the MySQL daemon is automatically restarted after the
  crash. (CVE-2006-7232, CVE-2007-1420, CVE-2007-2583)
  
  As well, these updated packages fix the following bugs:
  
  * a separate counter was used for &quot;insert delayed&quot; statements, which caused
  rows to be discarded. In these updated packages, &quot;insert delayed&quot;
  statements no longer use a separate counter, which resolves this issue.
  
  * due to a bug in the Native POSIX Thread Library, in certain situations,
  &quot;flush tables&quot; caused a deadlock on tables that had a read lock. The mysqld
  daemon had to be ki ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  mysql on Red Hat Enterprise Linux (v. 5 server)

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-May/msg00021.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mysql");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_5")
{

  if(isrpmvuln(pkg:"mysql", rpm:"mysql~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-debuginfo", rpm:"mysql-debuginfo~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-devel", rpm:"mysql-devel~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-server", rpm:"mysql-server~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-test", rpm:"mysql-test~5.0.45~7.el5", rls:"RHENT_5"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}