###############################################################################
# OpenVAS Vulnerability Test
#
# RedHat Update for seamonkey RHSA-2008:0882-01
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(870142);
  script_version("$Revision: 1.0 $");
  script_xref(name: "RHSA", value: "2008:0882-01");
  script_cve_id("CVE-2008-0016", "CVE-2008-3835", "CVE-2008-3837", "CVE-2008-4058", "CVE-2008-4059", "CVE-2008-4060", "CVE-2008-4061", "CVE-2008-4062", "CVE-2008-4065", "CVE-2008-4066", "CVE-2008-4067", "CVE-2008-4068", "CVE-2008-4069");
  script_name(english: "RedHat Update for seamonkey RHSA-2008:0882-01");
  desc["english"] = "

  Vulnerability Insight:
  SeaMonkey is an open source Web browser, advanced email and newsgroup
  client, IRC chat client, and HTML editor.
  
  Several flaws were found in the processing of malformed web content. A web
  page containing malicious content could cause SeaMonkey to crash or,
  potentially, execute arbitrary code as the user running SeaMonkey.
  (CVE-2008-0016, CVE-2008-4058, CVE-2008-4059, CVE-2008-4060, CVE-2008-4061,
  CVE-2008-4062)
  
  Several flaws were found in the way malformed web content was displayed. A
  web page containing specially crafted content could potentially trick a
  SeaMonkey user into surrendering sensitive information. (CVE-2008-3835,
  CVE-2008-4067, CVE-2008-4068, CVE-2008-4069)
  
  A flaw was found in the way SeaMonkey handles mouse click events. A web page
  containing specially crafted JavaScript code could move the content window
  while a mouse-button was pressed, causing any item under the pointer to be
  dragged. This could, potentially, cause the user to perform an unsafe
  drag-and-drop action. (CVE-2008-3837)
  
  A flaw was found in SeaMonkey that caused certain characters to be stripped
  from JavaScript code. This flaw could allow malicious JavaScript to bypass
  or evade script filters. (CVE-2008-4065, CVE-2008-4066)
  
  All SeaMonkey users should upgrade to these updated packages, which contain
  backported patches to resolve these issues.


  Affected Software/OS:
  seamonkey on Red Hat Enterprise Linux AS (Advanced Server) version 2.1,
  Red Hat Enterprise Linux ES version 2.1,
  Red Hat Enterprise Linux WS version 2.1,
  Red Hat Enterprise Linux AS version 3,
  Red Hat Enterprise Linux ES version 3,
  Red Hat Enterprise Linux WS version 3,
  Red Hat Enterprise Linux AS version 4,
  Red Hat Enterprise Linux ES version 4,
  Red Hat Enterprise Linux WS version 4

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/rhsa-announce/2008-September/msg00012.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Red Hat Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "RHENT_2.1")
{

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.20.el2", rls:"RHENT_2.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_4")
{

  if(isrpmvuln(pkg:"devhelp", rpm:"devhelp~0.10~0.10.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-debuginfo", rpm:"devhelp-debuginfo~0.10~0.10.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"devhelp-devel", rpm:"devhelp-devel~0.10~0.10.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~26.el4", rls:"RHENT_4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "RHENT_3")
{

  if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-chat", rpm:"seamonkey-chat~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-devel", rpm:"seamonkey-devel~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-dom-inspector", rpm:"seamonkey-dom-inspector~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-js-debugger", rpm:"seamonkey-js-debugger~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-mail", rpm:"seamonkey-mail~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr", rpm:"seamonkey-nspr~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nspr-devel", rpm:"seamonkey-nspr-devel~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss", rpm:"seamonkey-nss~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"seamonkey-nss-devel", rpm:"seamonkey-nss-devel~1.0.9~0.24.el3", rls:"RHENT_3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}