###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_air_js_code_exec_vuln.nasl 510 2008-11-20 12:28:26Z nov $
#
# Adobe AIR JavaScript Code Execution Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800065);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5108");
  script_bugtraq_id(32334);
  script_name(english:"Adobe AIR JavaScript Code Execution Vulnerability");
  desc["english"] = "

  Overview: This host has Adobe AIR installed, and is prone to privilege
  escalation vulnerability.

  Vulnerability Insight:
  The issue is caused due to improper sanitization of Javascript in the
  application.

  Impact: Remote exploitation could lead to unauthorized disclosure of
  information, modification of files, and disruption of service.

  Impact Level: Application

  Affected Software/OS:
  Adobe AIR 1.1 and earlier on Windows.

  Fix: Upgrade to Adobe AIR 1.5
  http://get.adobe.com/air

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Adobe AIR");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!(get_kb_item("SMB/WindowsVersion"))){
  exit(0);
}

airVer = registry_get_sz(item:"DisplayVersion",
         key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Adobe AIR");
if(airVer)
{
  if(version_is_less(version:airVer, test_version:"1.5.0.7220")){
    security_warning(0);
  }
}
