##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clamav_detect_lin.nasl 1466 2009-04-13 09:52:37Z apr $
#
# CalmAV Version Detection (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800553);
  script_version("$Revision: 1.1 $");
  script_name(english:"ClamAV Version Detection (Linux)");
  desc["english"] = "
  Overview : This script retrieves ClamAV Version and saves the result
  in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_family(english:"Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_summary(english:"Set Version of ClamAV in KB");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"clamscan", sock:sock);
foreach binaryFile (getPath)
{
  avVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"ClamAV ([0-9.]+)", sock:sock);
  if(avVer[1] != NULL)
  {
    set_kb_item(name:"ClamAV/Lin/Ver", value:avVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
