###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_dovecot_mult_sec_bypass_vuln.nasl 344 2008-10-17 11:17:55Z oct $
#
# Dovecot ACL Plugin Security Bypass Vulnerabilities
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800030);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4577", "CVE-2008-4578");
  script_bugtraq_id(31587);
  script_name(english:"Dovecot ACL Plugin Security Bypass Vulnerabilities");
  desc["english"] = "
  Overview: This host has Dovecot ACL Plugin installed and is prone to
  multiple security bypass vulnerabilities.

  Vulnerability Insight:
  The flaws are due to,
  - the ACL plugin interprets negative access rights as positive access rights,
    potentially giving an unprivileged user access to restricted resources.
  - an error in the ACL plugin when imposing mailbox creation restrictions to
    to create parent/child/child mailboxes.

  Impact: Successful attack could allow malicious people to bypass certain
  security restrictions or manipulate certain data.

  Impact Level: Application

  Affected Software/OS:
  Dovecot versions prior to 1.1.4 on Linux

  Fix: Upgrade to Dovecot version 1.1.4
  http://www.dovecot.org/download.html

  References:
  http://www.frsirt.com/english/advisories/2008/2745
  http://www.dovecot.org/list/dovecot-news/2008-October/000085.html

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 4.3
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"dovecot", sock:sock);
foreach binary_File (getPath)
{
  doveVer = get_bin_version(full_prog_name:chomp(binary_File), version_argv:"--version",
                            ver_pattern:"[0-9.]+", sock:sock);
  if(doveVer)
  {
    if(version_is_less(version:doveVer[0], test_version:"1.1.4")){
      security_warning(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
