###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_expressionengine_xss_vuln.nasl 1263 2009-04-01 19:10:34Z apr $
#
# ExpressionEngine CMS Cross Site Scripting Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800263);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1070");
  script_bugtraq_id(34193);
  script_name(english:"ExpressionEngine CMS Cross Site Scripting Vulnerability");
  desc["english"] = "

  Overview:
  This host is running ExpressionEngine CMS and is prone to Cross Site
  Scripting vulnerability.

  Vulnerability Insight:
  Inadequate validation of user supplied input to the system/index.php script
  leads to cross site attacks.

  Impact:
  Successful exploitation will allow remote attackers to inject arbitrary HTML
  codes in an image by tricking the user to view a malicious profile page.

  Impact Level: Application

  Affected Software/OS:
  ExpresssionEngine versions prior to 1.6.7 on all platforms.

  Fix:
  Update ExpressionEngine to version 1.6.7
  http://expressionengine.com

  References:
  http://secunia.com/advisories/34379
  http://xforce.iss.net/xforce/xfdb/49359
  http://www.securityfocus.com/archive/1/archive/1/502045/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check version of ExpressionEngine CMS");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Web application abuses");
  script_dependencies("gb_expressionengine_detect.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}

include("http_func.inc");
include("version_func.inc");

httpPort = get_http_port(default:80);
if(!httpPort){
  exit(0);
}

expressionVer = get_kb_item("www/" + httpPort + "/ExpEngine");
if(expressionVer == NULL){
  exit(0);
}

if(version_is_less(version:expressionVer, test_version:"1.6.7")){
  security_warning(httpPort);
}
