###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cpio FEDORA-2007-2827
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861356);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-2827");
  script_cve_id("CVE-2007-4476");
  script_name(english: "Fedora Update for cpio FEDORA-2007-2827");
  desc["english"] = "

  Vulnerability Insight:
  GNU cpio copies files into or out of a cpio or tar archive.  Archives
  are files which contain a collection of other files plus information
  about them, such as their file name, owner, timestamps, and access
  permissions.  The archive can be another file on the disk, a magnetic
  tape, or a pipe.  GNU cpio supports the following archive formats:  binary,
  old ASCII, new ASCII, crc, HPUX binary, HPUX old ASCII, old tar and POSIX.1
  tar.  By default, cpio creates binary format archives, so that they are
  compatible with older cpio programs.  When it is extracting files from
  archives, cpio automatically recognizes which kind of archive it is reading
  and can read archives created on machines with a different byte-order.
  
  Install cpio if you need a program to manage file archives.


  Affected Software/OS:
  cpio on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00118.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of cpio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.9~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cpio-debuginfo", rpm:"cpio-debuginfo~2.9~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.9~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cpio-debuginfo", rpm:"cpio-debuginfo~2.9~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"cpio", rpm:"cpio~2.9~5.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}