###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for ruby-gnome2 FEDORA-2007-4229
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861122);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4229");
  script_cve_id("CVE-2007-6183");
  script_name(english: "Fedora Update for ruby-gnome2 FEDORA-2007-4229");
  desc["english"] = "

  Vulnerability Insight:
  This is a set of bindings for the GNOME-2.x libraries for use from Ruby.


  Affected Software/OS:
  ruby-gnome2 on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00251.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of ruby-gnome2");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"ruby-gnome2", rpm:"ruby-gnome2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-rsvg", rpm:"ruby-rsvg~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkhtml2", rpm:"ruby-gtkhtml2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomeprint2", rpm:"ruby-gnomeprint2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-pango-devel", rpm:"ruby-pango-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-glib2", rpm:"ruby-glib2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-atk-devel", rpm:"ruby-atk-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomeprintui2", rpm:"ruby-gnomeprintui2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libart2", rpm:"ruby-libart2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtk2-devel", rpm:"ruby-gtk2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-panelapplet2", rpm:"ruby-panelapplet2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-glib2-devel", rpm:"ruby-glib2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gconf2", rpm:"ruby-gconf2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gdkpixbuf2", rpm:"ruby-gdkpixbuf2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomevfs", rpm:"ruby-gnomevfs~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnome2", rpm:"ruby-gnome2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkglext", rpm:"ruby-gtkglext~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomecanvas2", rpm:"ruby-gnomecanvas2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-vte", rpm:"ruby-vte~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-poppler", rpm:"ruby-poppler~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libglade2", rpm:"ruby-libglade2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkmozembed", rpm:"ruby-gtkmozembed~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtksourceview", rpm:"ruby-gtksourceview~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnome2-debuginfo", rpm:"ruby-gnome2-debuginfo~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-pango", rpm:"ruby-pango~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-atk", rpm:"ruby-atk~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libart2-devel", rpm:"ruby-libart2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtk2", rpm:"ruby-gtk2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libart2", rpm:"ruby-libart2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnome2-debuginfo", rpm:"ruby-gnome2-debuginfo~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libart2-devel", rpm:"ruby-libart2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-atk", rpm:"ruby-atk~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-poppler", rpm:"ruby-poppler~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkglext", rpm:"ruby-gtkglext~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnome2", rpm:"ruby-gnome2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-libglade2", rpm:"ruby-libglade2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-vte", rpm:"ruby-vte~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtksourceview", rpm:"ruby-gtksourceview~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtk2-devel", rpm:"ruby-gtk2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-panelapplet2", rpm:"ruby-panelapplet2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomecanvas2", rpm:"ruby-gnomecanvas2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-pango-devel", rpm:"ruby-pango-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomeprintui2", rpm:"ruby-gnomeprintui2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gdkpixbuf2", rpm:"ruby-gdkpixbuf2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-atk-devel", rpm:"ruby-atk-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomeprint2", rpm:"ruby-gnomeprint2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtk2", rpm:"ruby-gtk2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkhtml2", rpm:"ruby-gtkhtml2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-pango", rpm:"ruby-pango~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gtkmozembed", rpm:"ruby-gtkmozembed~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-glib2", rpm:"ruby-glib2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gnomevfs", rpm:"ruby-gnomevfs~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-rsvg", rpm:"ruby-rsvg~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-glib2-devel", rpm:"ruby-glib2-devel~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"ruby-gconf2", rpm:"ruby-gconf2~0.16.0~18.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}