###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for eggdrop FEDORA-2007-4325
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861026);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-4325");
  script_cve_id("CVE-2007-2807");
  script_name(english: "Fedora Update for eggdrop FEDORA-2007-4325");
  desc["english"] = "

  Vulnerability Insight:
  Eggdrop is the world's most popular Open Source IRC bot, designed
  for flexibility and ease of use. It is extendable with Tcl scripts
  and/or C modules, has support for the big five IRC networks and is
  able to form botnets, share partylines and userfiles between bots.


  Affected Software/OS:
  eggdrop on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-December/msg00348.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of eggdrop");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"eggdrop", rpm:"eggdrop~1.6.18~12.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eggdrop-debuginfo", rpm:"eggdrop-debuginfo~1.6.18~12.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eggdrop", rpm:"eggdrop~1.6.18~12.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eggdrop", rpm:"eggdrop~1.6.18~12.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"eggdrop-debuginfo", rpm:"eggdrop-debuginfo~1.6.18~12.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}