###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for kdelibs FEDORA-2007-716
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861369);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-716");
  script_cve_id("CVE-2007-4224", "CVE-2007-3820");
  script_name(english: "Fedora Update for kdelibs FEDORA-2007-716");
  desc["english"] = "

  Vulnerability Insight:
  Libraries for the K Desktop Environment:
  KDE Libraries included: kdecore (KDE core library), kdeui (user interface),
  kfm (file manager), khtmlw (HTML widget), kio (Input/Output, networking),
  kspell (spelling checker), jscript (javascript), kab (addressbook),
  kimgio (image manipulation)


  Affected Software/OS:
  kdelibs on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00085.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kdelibs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"kdelibs", rpm:"kdelibs~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdelibs-devel", rpm:"x86_64/kdelibs-devel~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdelibs", rpm:"x86_64/kdelibs~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/kdelibs-debuginfo", rpm:"x86_64/debug/kdelibs-debuginfo~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/kdelibs-apidocs", rpm:"x86_64/kdelibs-apidocs~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/kdelibs-debuginfo", rpm:"i386/debug/kdelibs-debuginfo~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdelibs-apidocs", rpm:"i386/kdelibs-apidocs~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdelibs-devel", rpm:"i386/kdelibs-devel~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/kdelibs", rpm:"i386/kdelibs~3.5.7~1.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}