###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for flac FEDORA-2007-730
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861109);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2007-730");
  script_cve_id("CVE-2007-4619");
  script_name(english: "Fedora Update for flac FEDORA-2007-730");
  desc["english"] = "

  Vulnerability Insight:
  FLAC stands for Free Lossless Audio Codec. Grossly oversimplified, FLAC
  is similar to Ogg Vorbis, but lossless. The FLAC project consists of
  the stream format, reference encoders and decoders in library form,
  flac, a command-line program to encode and decode FLAC files, metaflac,
  a command-line metadata editor for FLAC files and input plugins for
  various music players


  Affected Software/OS:
  flac on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-November/msg00068.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of flac");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"flac", rpm:"flac~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/flac-devel", rpm:"x86_64/flac-devel~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/flac-debuginfo", rpm:"x86_64/debug/flac-debuginfo~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/flac", rpm:"x86_64/flac~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/flac", rpm:"i386/flac~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/flac-devel", rpm:"i386/flac-devel~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/flac-debuginfo", rpm:"i386/debug/flac-debuginfo~1.1.2~28", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}