###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for sipp FEDORA-2008-6210
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860882);
  script_version("$Revision: 1.0 $");
  script_xref(name: "FEDORA", value: "2008-6210");
  script_cve_id("CVE-2008-2085");
  script_name(english: "Fedora Update for sipp FEDORA-2008-6210");
  desc["english"] = "

  Vulnerability Insight:
  SIPp is a free Open Source test tool / traffic generator for the SIP protocol.
  It includes a few basic SipStone user agent scenarios (UAC and UAS) and
  establishes and releases multiple calls with the INVITE and BYE methods. It
  can also reads custom XML scenario files describing from very simple to
  complex call flows. It features the dynamic display of statistics about
  running tests (call rate, round trip delay, and message statistics), periodic
  CSV statistics dumps, TCP and UDP over multiple sockets or multiplexed with
  retransmission management and dynamically adjustable call rates.


  Affected Software/OS:
  sipp on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-July/msg00311.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of sipp");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"sipp", rpm:"sipp~3.1~2.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}