###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_foxmail_detect.nasl 816 2009-01-07 15:30:24Z jan $
#
# FoxMail Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800219);
  script_version("$Revision: 1.0 $");
  script_name(english:"FoxMail Version Detection");
  desc["english"] = "
  Overview : This script finds the installed FoxMail Version and saves in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set Version of FoxMail in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Tencent\Foxmail")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Foxmail_is1\";
if("Foxmail" >< registry_get_sz(key:key, item:"DisplayName"))
{
  name = registry_get_sz(key:key, item:"DisplayName");
  foxmailVer = eregmatch(pattern:"Foxmail ([0-9.]+)", string:name);
  if(foxmailVer[1] != NULL){
    set_kb_item(name:"Foxmail/Win/Ver", value:foxmailVer[1]);
  }
  exit(0);
}
