###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_fsecure_prdts_detect_win.nasl 995 2009-03-12 15:14:29Z mar $
#
# F-Secure Multiple Products Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800355);
  script_version("$Revision: 1.0 $");
  script_name(english:"F-Secure Multiple Products Version Detection (Win)");
  desc["english"] = "
  Overview: The script detects the installed version of F-Secure Anti-Virus
  (for MS Exchange), Workstations and Internet GateKeeper & sets the version
  in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets the Version of F-Secure Products");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Data Fellows\F-Secure")){
  exit(0);
}

# Set the Version for F-Secure Anti-Virus
fsavVer = registry_get_sz(key:"SOFTWARE\Data Fellows\F-Secure\Anti-Virus",
                          item:"CurrentVersionEx");
if(fsavVer){
  set_kb_item(name:"F-Sec/AV/Win/Ver", value:fsavVer);
}

# Set the Version for F-Secure Anti-Virus for Internet Gatekeeper
fsigkVer = registry_get_sz(key:"SOFTWARE\Data Fellows\F-Secure" +
                               "\Anti-Virus for Internet Gateways",
                           item:"CurrentVersion");
if(fsigkVer){
  set_kb_item(name:"F-Sec/AV/IntGatekeeper/Win/Ver", value:fsigkVer);
}

# Set the Version for F-Secure Anti-Virus for Microsoft Exchange
fsavmeVer = registry_get_sz(key:"SOFTWARE\Data Fellows\F-Secure" +
                                "\Anti-Virus Agent for Microsoft Exchange",
                            item:"CurrentVersion");
if(fsavmeVer){
  set_kb_item(name:"F-Sec/AV/MSExchange/Ver", value:fsavmeVer);
}
