###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_bof_vuln.nasl 2202 08-05-2009 16:42:10Z may $
#
# Google Chrome Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800567);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1441", "CVE-2009-1442");
  script_name(english:"Google Chrome Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview: The host is installed with Google Chrome and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  These flaws are due to,
  - a boundary error in nitSkBitmapFromData() function while processing
    vectors related to large bitmap that arrives over the IPC channel.
  - a failure while validating the result of integer multiplication when
    computing image sizes.

  Impact:
  Successful exploitation will let the attacker run arbitrary codes with the
  privilege of logged on user or can craft a special images or canvas to
  execute arbitrary code inside the sandboxed renderer (tab) process and cause
  a tab to crash.

  Impact level: Application

  Affected Software/OS:
  Google Chrome versions prior to 1.0.154.64, version 2.0.159.0 and prior.

  Fix: Upgrade to version 1.0.154.64
  http://www.google.com/chrome

  References:
  http://code.google.com/p/chromium/issues/detail?id=10869
  http://googlechromereleases.blogspot.com/2009/05/stable-update-security-fix.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Buffer overflow");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(chromeVer == NULL){
  exit(0);
}

if(version_in_range(version:chromeVer, test_version:"2.0", test_version2:"2.0.159.0")||
   version_is_less (version:chromeVer, test_version:"1.0.154.64")){
  security_hole(0);
}
