###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_chrome_ftp_clnt_xss_vuln.nasl 388 2008-10-30 11:22:09Z oct $
#
# Google Chrome Web Browser FTP Client XSS Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800121);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4724");
  script_bugtraq_id(31855);
  script_name(english:"Google Chrome Web Browser FTP Client XSS Vulnerability");
  desc["english"] = "

  Overview: The host is installed with Goole Chrome Web Browser and is prone to
  Cross Site Scripting (XSS) Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the way browser handles web script or html via
  ftp://URL for an html document within a JPG, PDF, or TXT files.

  Impact: Successful remote attack result in injection of arbitrary web
  script or HTML code.

  Impact Level: Application

  Affected Software/OS:
  Google Chrome version 0.2.149 30 and prior on all running platform.

  Fix: No solution/patch is available as on 31st October, 2008. Information
  regarding this issue will be updated once the solution details are available.

  References:
  http://www.securityfocus.com/bid/31855
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4724

  CVSS Score:
    CVSS Base Score     : 5.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.2
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Google Chrome");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("gb_google_chrome_detect_win.nasl");
  script_require_keys("GoogleChrome/Win/Ver");
  exit(0);
}


include("version_func.inc");

chromeVer = get_kb_item("GoogleChrome/Win/Ver");
if(!chromeVer){
  exit(0);
}

if(version_is_less_equal(version:chromeVer, test_version:"0.2.149.30")){
  security_hole(0);
}
