###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for BIND v920 HPSBUX00290
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835007);
  script_version("$Revision: 1.0 $");
  script_xref(name: "HPSBUX", value: "00290");
  script_cve_id("CAN-2003-0543", "CAN-2003-0544", "CAN-2003-0545");
  script_name(english: "HP-UX Update for BIND v920 HPSBUX00290");
  desc["english"] = "

  Vulnerability Insight:
  1. Certain ASN.1 encodings that are rejected as invalidby the parser can 
  trigger a bug in the deallocationof the corresponding data structure, 
  corrupting thestack. This can be used as a denial of serviceattack. It is 
  currently unknown whether this can beexploited to run malicious code. This 
  issue does notaffect OpenSSL 0.9.6.<br2. Unusual ASN.1 tag values can cause 
  an out of boundsread under certain circumstances, resulting in adenial of 
  service vulnerability.<br3. A malformed public key in a certificate will 
  crashthe verify code if it is set to ignore public keydecoding errors. 
  Exploitation of an affectedapplication would result in a denial of 
  servicevulnerability.<br4. Due to an error in the SSL/TLS protocol 
  handling,a server will parse a client certificate when one isnot 
  specifically requested. 

  Impact:
  Remote Denial of Service (DoS)

  Affected Software/OS:
  BIND v920 on
  HP-UX B.11.00, B.11.11, B.11.22, and B.11.23, running BINDv920. 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00901847-1

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of BIND v920");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"BINDv920.INETSVCS-BIND", revision:"B.11.00.01.003", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-RUN", patch_list:['PHNE_29859'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"BINDv920.INETSVCS-BIND", revision:"B.11.11.01.005", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"InternetSrvcs.INETSVCS2-RUN", patch_list:['PHNE_31726'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
