###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ktorrent_detect.nasl 850 2009-01-20 10:57:24Z jan $
#
# KTorrent Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800341);
  script_version("Revision: 1.0 ");
  script_name(english:"KTorrent Version Detection (Linux)");
  desc["english"] = "
  Overview : This script finds the installed version of KTorrent and saves
  the result in KB.

  Risk factor : Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Set KB for the version of KTorrent");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"General");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

paths = find_file(file_name:"ktorrent",file_path:"/", useregex:TRUE,
                 regexpar:"$", sock:sock);
foreach ktBin (paths)
{
  ktVer = get_bin_version(full_prog_name:chomp(ktBin), sock:sock,
                           version_argv:"--version",
                           ver_pattern:"KTorrent: ([0-9.a-z]+)");
  if(ktVer[1] != NULL)
  {
    set_kb_item(name:"KTorrent/Linux/Ver", value:ktVer[1]);
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
