###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for xorg-x11 MDKSA-2007-005 (xorg-x11)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830008);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007-005");
  script_cve_id("CVE-2006-6101", "CVE-2006-6102", "CVE-2006-6103");
  script_name(english: "Mandriva Update for xorg-x11 MDKSA-2007-005 (xorg-x11)");
  desc["english"] = "

  Vulnerability Insight:

  Sean Larsson of iDefense Labs discovered several vulnerabilities in
  X.Org/XFree86:
  
  Local exploitation of a memory corruption vulnerability in the
  'ProcRenderAddGlyphs()' function in the X.Org and XFree86 X server
  could allow an attacker to execute arbitrary code with privileges of
  the X server, typically root. (CVE-2006-6101)
  
  Local exploitation of a memory corruption vulnerability in the
  'ProcDbeGetVisualInfo()' function in the X.Org and XFree86 X server
  could allow an attacker to execute arbitrary code with privileges of
  the X server, typically root. (CVE-2006-6102)
  
  Local exploitation of a memory corruption vulnerability in the
  'ProcDbeSwapBuffers()' function in the X.Org and XFree86 X server could
  allow an attacker to execute arbitrary code with privileges of the X
  server, typically root. (CVE-2006-6103)
  
  Updated packages are patched to address these issues.

  Affected Software/OS:
  xorg-x11 on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of xorg-x11");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"x11-server", rpm:"x11-server~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-common", rpm:"x11-server-common~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-devel", rpm:"x11-server-devel~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xati", rpm:"x11-server-xati~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xchips", rpm:"x11-server-xchips~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xdmx", rpm:"x11-server-xdmx~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xephyr", rpm:"x11-server-xephyr~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xepson", rpm:"x11-server-xepson~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfake", rpm:"x11-server-xfake~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfbdev", rpm:"x11-server-xfbdev~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xi810", rpm:"x11-server-xi810~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmach64", rpm:"x11-server-xmach64~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmga", rpm:"x11-server-xmga~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xneomagic", rpm:"x11-server-xneomagic~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnest", rpm:"x11-server-xnest~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnvidia", rpm:"x11-server-xnvidia~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xorg", rpm:"x11-server-xorg~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xpm2", rpm:"x11-server-xpm2~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xprt", rpm:"x11-server-xprt~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xr128", rpm:"x11-server-xr128~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsdl", rpm:"x11-server-xsdl~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsmi", rpm:"x11-server-xsmi~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvesa", rpm:"x11-server-xvesa~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvfb", rpm:"x11-server-xvfb~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvia", rpm:"x11-server-xvia~1.1.1~11.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}