###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for bind MDKSA-2007:030 (bind)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830047);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDKSA", value: "2007:030");
  script_cve_id("CVE-2007-0493", "CVE-2007-0494");
  script_name(english: "Mandriva Update for bind MDKSA-2007:030 (bind)");
  desc["english"] = "

  Vulnerability Insight:

  Use-after-free vulnerability in ISC BIND 9.3.0 up to 9.3.3, 9.4.0a1 up
  to 9.4.0a6, 9.4.0b1 up to 9.4.0b4, 9.4.0rc1, and 9.5.0a1 (Bind Forum
  only) allows remote attackers to cause a denial of service (named
  daemon crash) via unspecified vectors that cause named to &quot;dereference
  a freed fetch context.&quot; (CVE-2007-0493)
  
  ISC BIND 9.0.x, 9.1.x, 9.2.0 up to 9.2.7, 9.3.0 up to 9.3.3, 9.4.0a1 up
  to 9.4.0a6, 9.4.0b1 up to 9.4.0b4, 9.4.0rc1, and 9.5.0a1 (Bind Forum
  only) allows remote attackers to cause a denial of service (exit) via a
  type * (ANY) DNS query response that contains multiple RRsets, which
  triggers an assertion error. (CVE-2007-0494)
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  bind on Mandriva Linux 2006.0,
  Mandriva Linux 2006.0/X86_64,
  Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-01/msg00044.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.2~8.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.2~8.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.2~8.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2006.0")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.1~4.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.1~4.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.1~4.3.20060mdk", rls:"MNDK_2006.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}